require( "HiddenObject/script/style.lua" );

kButtonSpacing = 48;	-- Put our buttons 60 pixels apart
kButtonY = kCenter-55;	-- Three buttons means center 60 pixels above the center

-- When this dialog is popped up, we're entering pause state, so
-- let's just notify TGameState now.
SetState( kPause, true );


HeaderShadowFont = {
  standardFont,
  36,
  Color(0,0,0),
};

HeaderFont = {
  standardFont,
  36,
  Color(131,167,184),
};

PauseButtonFont = {
  standardFont,
  24,
  Color(131,167,184),
};


PauseButtonGraphics = {
	"HiddenObject/UI/Button/pausebuttonnormal",
	"HiddenObject/UI/Button/pausebuttondown",
	"HiddenObject/UI/Button/pausebuttonover",
};	

PauseButtonStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	graphics = PauseButtonGraphics,
	font = PauseButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};



OkButtonGraphics = {
	"HiddenObject/UI/Button/oknormal",
	"HiddenObject/UI/Button/okdown",
	"HiddenObject/UI/Button/okover",
};	

OkButtonStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = PauseButtonFont,
	graphics = OkButtonGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

MakeDialog
{
	-- Name the modal dialog
	name="pausemenu",
	Bitmap
	{
		image="HiddenObject/UI/background/pausedialog",
		x=kCenter,
		y=kCenter - 44,
		
				
		Text
		{
			font = HeaderShadowFont,
			name = "gamepausedshadow",
			x=kCenter,y=20,w=kMax,h=40,
			flags = kHAlignCenter + kVAlignCenter,
			label = "gamepaused";
		};
		
				
		Text
		{
			font = HeaderFont,
			name = "gamepaused",
			x=kCenter,y=20,w=kMax,h=40,
			flags = kHAlignCenter + kVAlignCenter,
			label = "gamepaused";
		};

		SetStyle(PauseButtonStyle),
		Button
		{
			x=kCenter,
			y=kButtonY,
			label="options",
			command=
				function()
					-- Pop up an options screen					
					DoModal("HiddenObject/script/options.lua");
				end
		},

		Button
		{
			x=kCenter,
			y=kButtonY + 2*kButtonSpacing,
			label="mainmenu",
			command=
				function()
 					info = GetGame();
 					
 					local result = "yes";
 					
 					if info == "hiddenObjectGame" then
 					 	result = DisplayDialog {	"HiddenObject/script/saveinfo.lua", title = info, body = "saveinfo",};					
 					else
 						if info ~= "" then result = DisplayDialog {	"HiddenObject/script/saveinfo.lua", title = info, body = "quit2menu",}; end
 					end
                    if(result == "yes") then 
						SendGameMessage( "quit" ); 
						PopAllChildWindows();
						SwapToModal('HiddenObject/Script/mainmenu.lua');						
                    end
				end
		},

		Button
		{
			x=kCenter,
			y=kButtonY+ kButtonSpacing,
			label="help",
			command=
				function()
						DoModal("HiddenObject/Script/help.lua");
					end
		},
		SetStyle(OkButtonStyle),
		Button
		{
			x=kCenter,
			y=-80,
			label="resume",
			close = true,	-- Just close this window
			command=
				function()
	                SetState( kPause, false );
	                if(SendGameMessage) then 
						SendGameMessage('resume');
					end
				end;

		},


	},
}